package ru.yandex.direct.utils.json;

import java.util.List;
import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JSonSplitter {
    private static final Pattern SPLIT_JSON_PATTERN = Pattern.compile("}\\s*\\n\\s*\\{");

    private JSonSplitter() {
    }

    public static String[] splitJsons(String strData) {
        String[] split = SPLIT_JSON_PATTERN.split(strData);
        for (int i = 1; i < split.length; i++) {
            split[i - 1] += "}";
            split[i] = "{" + split[i];
        }
        return split;
    }

    public static String combineJsons(List<String> jsons) {
        return String.join("\n", jsons);
    }
}
