package ru.yandex.direct.utils.math;

import java.util.Comparator;
import java.util.Objects;

import javax.annotation.Nonnull;

public class Point implements Comparable<Point> {
    public static final Comparator<Point> COMPARATOR = Point::compareTo;
    public static final Point ZERO = fromDoubles(0, 0);
    private final double x;
    private final double y;


    private Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Point fromDoubles(double x, double y) {
        return new Point(x, y);
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    @Override
    public int compareTo(@Nonnull Point o) {
        int ret = Double.compare(x, o.x);
        if (ret != 0) {
            return ret;
        }
        return Double.compare(y, o.y);
    }

    @Override
    public String toString() {
        return "Point{" +
                "x=" + x +
                ", y=" + y +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point point = (Point) o;
        return this.compareTo(point) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(getX(), getY());
    }
}
