package ru.yandex.direct.validation.builder;

import java.util.function.Consumer;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class BuilderUtils {
    private BuilderUtils() {
    }

    static <T, D> void check(@Nullable T value, Constraint<T, D> constraint, @Nullable D overrideDefect,
                             Consumer<D> defectConsumer) {
        D defect = constraint.apply(value);
        if (defect != null) {
            defectConsumer.accept(overrideDefect == null ? defect : overrideDefect);
        }
    }
}
