package ru.yandex.direct.validation.builder;

import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * Констрейнт для списка: получает на вход список,
 * возвращает дефекты для элементов списка в виде
 * ассоциативного массива индекс -> дефект.
 * <p>
 * Нужен для проверок элементов в контексте списка,
 * например, для проверки отсутствия дубликатов.
 * <p>
 * Является точкой расширения: методы проверок в ItemValidationBuilder и ListValidationBuilder
 * принимают интерфейс {@code ListConstraint}, который можно имплементировать в клиентском коде.
 * Библиотека не содержит ни специфических дефектов, ни констрейнтов.
 *
 * @param <I> тип проверяемых элементов списка
 * @param <D> тип дефекта
 */
public interface ListConstraint<I, D> extends Function<List<I>, Map<Integer, D>> {
}
