package ru.yandex.direct.validation.builder;

import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Интерфейс валидатора для отдельного элемента валидируемого списка.
 * Принимает индекс элемента вместе с самим элементом и возвращает ValidationResult&lt;T, D&gt;
 *
 * @param <T> тип валидируемого объекта
 * @param <D> тип дефекта
 */
@FunctionalInterface
public interface ListItemValidator<T, D> {
    ValidationResult<T, D> validate(int index, T item);
}
