package ru.yandex.direct.validation.constraint;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.base.CharMatcher;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.defect.StringDefects;
import ru.yandex.direct.validation.result.Defect;

import static com.google.common.base.Strings.isNullOrEmpty;

@ParametersAreNonnullByDefault
public class AdmissibleCharsConstraint implements Constraint<String, Defect> {

    private final String admissibleChars;
    private final CharMatcher availableCharMatcher;
    private final Defect defect;


    public AdmissibleCharsConstraint(String admissibleChars) {
        this(admissibleChars, StringDefects.admissibleChars());
    }

    public AdmissibleCharsConstraint(String admissibleChars, Defect defect) {
        Objects.requireNonNull(admissibleChars, "admissibleChars");
        Objects.requireNonNull(defect, "defect");

        this.admissibleChars = admissibleChars;
        this.availableCharMatcher = CharMatcher.anyOf(admissibleChars);
        this.defect = defect;
    }

    @Override
    public String toString() {
        return "AdmissibleCharsConstraint{" +
                "admissibleChars='" + admissibleChars + '\'' +
                ", availableCharMatcher=" + availableCharMatcher +
                ", defect=" + defect +
                '}';
    }

    @Override
    public Defect apply(String string) {
        return isNullOrEmpty(string) || availableCharMatcher.matchesAllOf(string) ?
                null :
                defect;
    }
}
