package ru.yandex.direct.validation.constraint;

import java.time.LocalDate;
import java.time.LocalDateTime;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.defect.DateDefects;
import ru.yandex.direct.validation.result.Defect;

public class DateConstraints {

    private DateConstraints() {
    }

    // dates
    public static Constraint<LocalDate, Defect> isNotOlderThan(long days) {
        return t -> t.isBefore(LocalDate.now().minusDays(days)) ? DateDefects.notOlderThan(days) : null;
    }

    public static Constraint<LocalDate, Defect> isNotBeforeThan(LocalDate date) {
        return t -> t.isBefore(date) ? DateDefects.greaterThanOrEqualTo(date) : null;
    }

    public static Constraint<LocalDate, Defect> isAfterThan(LocalDate date) {
        return t -> !t.isAfter(date) ? DateDefects.greaterThan(date) : null;
    }

    public static Constraint<LocalDate, Defect> isNotAfterThan(LocalDate date) {
        return t -> t.isAfter(date) ? DateDefects.lessThanOrEqualTo(date) : null;
    }

    public static Constraint<LocalDate, Defect> endDateIsNotBeforeThan(LocalDate startDate) {
        return endDate -> endDate.isBefore(startDate) ?
                DateDefects.endDateMustBeGreatherThanOrEqualToStartDate() : null;
    }

    // times
    public static Constraint<LocalDateTime, Defect> isNotBeforeThan(LocalDateTime date) {
        return t -> t.isBefore(date) ? DateDefects.greaterThan(date) : null;
    }
}
