package ru.yandex.direct.validation.constraint;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static java.util.function.Predicate.not;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@ParametersAreNonnullByDefault
public abstract class LongsConstraint<T extends Collection<Long>> implements Constraint<T, Defect> {

    private final Predicate<Long> isValidLong;

    public LongsConstraint(Predicate<Long> isValidLong) {
        this.isValidLong = isValidLong;
    }

    @Override
    public final Defect apply(T longs) {
        List<Long> invalidLongs = filterList(longs, not(isValidLong));
        return invalidLongs.isEmpty() ? null : buildDefect(invalidLongs);
    }

    protected abstract Defect buildDefect(List<Long> invalidLongs);

}
