package ru.yandex.direct.validation.constraint;

import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@ParametersAreNonnullByDefault
public class PhoneNumberConstraints {
    private static final Pattern PHONE_NUMBER_PATTERN = Pattern.compile("\\+?\\d+(?:[ \\-]\\d+)*");

    public static Constraint<String, Defect> validPhoneNumber() {

        return Constraint.fromPredicate(phoneNumber -> PHONE_NUMBER_PATTERN.matcher(phoneNumber).matches(),
                invalidValue());
    }
}
