package ru.yandex.direct.validation.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;

import ru.yandex.direct.validation.builder.ListConstraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.defect.CollectionDefects.duplicatedElement;

public class SimpleUniqueItemsConstraint<I> implements ListConstraint<I, Defect> {

    private final Function<I, ?> getter;

    public SimpleUniqueItemsConstraint(Function<I, ?> getter) {
        this.getter = t -> t != null ? getter.apply(t) : null;
    }

    public SimpleUniqueItemsConstraint() {
        this.getter = t -> t;
    }

    @Override
    public Map<Integer, Defect> apply(List<I> list) {
        Map<Integer, Defect> defectMap = new HashMap<>();

        List<?> items = mapList(list, getter);
        Multiset<?> itemsMultiset = HashMultiset.create(items);

        for (int i = 0; i < list.size(); i++) {
            Object item = getter.apply(list.get(i));
            if (item != null && itemsMultiset.count(item) > 1) {
                defectMap.put(i, duplicatedElement());
            }
        }

        return defectMap;
    }
}
