package ru.yandex.direct.validation.constraint;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;

import ru.yandex.direct.validation.builder.ListConstraint;
import ru.yandex.direct.validation.defect.CollectionDefects;
import ru.yandex.direct.validation.result.Defect;


/**
 * Позволяет найти дубликаты с помощью переданного в конструкторе {@code comparator}'а.
 * Дубликатами считаются элементы, для которых {@link Comparator#compare(Object, Object) comparator.compare(..)}
 * возвращает {@code 0}.
 */
public class UniqueComparableItemsConstraint<I> implements ListConstraint<I, Defect> {

    private final Comparator<I> comparator;

    public UniqueComparableItemsConstraint(Comparator<I> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Map<Integer, Defect> apply(List<I> items) {
        Map<Integer, Defect> defectMap = new HashMap<>();

        Multiset<I> itemsMultiset = TreeMultiset.create(comparator);
        itemsMultiset.addAll(items);

        for (int i = 0; i < items.size(); i++) {
            Object item = items.get(i);
            if (item != null && itemsMultiset.count(item) > 1) {
                defectMap.put(i, CollectionDefects.duplicatedObject());
            }
        }

        return defectMap;
    }
}
