package ru.yandex.direct.validation.defect;

import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class CollectionDefects {

    private CollectionDefects() {
    }


    //collections
    public static Defect<CollectionSizeDefectParams> maxElementsPerRequest(int max) {
        return new Defect<>(CollectionDefectIds.Size.MAX_ELEMENTS_PER_REQUEST,
                new CollectionSizeDefectParams().withMaxSize(max));
    }

    public static Defect<CollectionSizeDefectParams> maxElementsExceeded(int max) {
        return new Defect<>(CollectionDefectIds.Size.MAX_ELEMENTS_EXCEEDED,
                new CollectionSizeDefectParams().withMaxSize(max));
    }

    public static Defect<Void> notEmptyCollection() {
        return new Defect<>(CollectionDefectIds.Gen.CANNOT_BE_EMPTY);
    }

    public static Defect<Void> isEmptyCollection() {
        return new Defect<>(CollectionDefectIds.Gen.MUST_BE_EMPTY);
    }

    public static Defect<CollectionSizeDefectParams> maxCollectionSize(int max) {
        return new Defect<>(CollectionDefectIds.Size.SIZE_CANNOT_BE_MORE_THAN_MAX,
                new CollectionSizeDefectParams().withMaxSize(max));
    }

    public static Defect<CollectionSizeDefectParams> minCollectionSize(int min) {
        return new Defect<>(CollectionDefectIds.Size.SIZE_CANNOT_BE_LESS_THAN_MIN,
                new CollectionSizeDefectParams().withMinSize(min));
    }

    public static Defect<CollectionSizeDefectParams> collectionSizeInInterval(int minSize, int maxSize) {
        return new Defect<>(CollectionDefectIds.Size.SIZE_MUST_BE_IN_INTERVAL,
                new CollectionSizeDefectParams()
                        .withMinSize(minSize)
                        .withMaxSize(maxSize));
    }

    public static Defect<CollectionSizeDefectParams> collectionSizeIsValid(int minSize, int maxSize) {
        return new Defect<>(CollectionDefectIds.Size.INVALID_COLLECTION_SIZE,
                new CollectionSizeDefectParams()
                        .withMinSize(minSize)
                        .withMaxSize(maxSize));
    }

    public static Defect<Void> duplicatedObject() {
        return new Defect<>(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS);
    }

    public static Defect<Void> duplicatedElement() {
        return new Defect<>(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS);
    }

    public static Defect<Void> inCollection() {
        return new Defect<>(CollectionDefectIds.Gen.MUST_BE_IN_COLLECTION);
    }

    public static Defect<Void> notInCollection() {
        return new Defect<>(CollectionDefectIds.Gen.MUST_NOT_BE_IN_COLLECTION);
    }

    public static Defect<Void> notContainNulls() {
        return new Defect<>(CollectionDefectIds.Gen.CANNOT_CONTAIN_NULLS);
    }

    //strings
    public static Defect<StringDefectParams> minStringLength(int minStringLength) {
        return new Defect<>(StringDefectIds.LENGTH_CANNOT_BE_LESS_THAN_MIN,
                new StringDefectParams().withMinLength(minStringLength));
    }

    public static Defect<StringDefectParams> maxStringLength(int maxStringLength) {
        return new Defect<>(StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX,
                new StringDefectParams().withMaxLength(maxStringLength));
    }
}
