package ru.yandex.direct.validation.defect;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectIds;

public class CommonDefects {

    private CommonDefects() {
    }

    public static Defect<Void> unknownParameter() {
        return new Defect<>(DefectIds.UNKNOWN_PARAMETER);
    }

    public static Defect<Void> invalidValue() {
        return new Defect<>(DefectIds.INVALID_VALUE);
    }

    public static Defect<Void> invalidFormat() {
        return new Defect<>(DefectIds.INVALID_FORMAT);
    }

    public static Defect<Void> notNull() {
        return new Defect<>(DefectIds.CANNOT_BE_NULL);
    }

    public static Defect<Void> isNull() {
        return new Defect<>(DefectIds.MUST_BE_NULL);
    }

    public static Defect<Void> validId() {
        return new Defect<>(DefectIds.MUST_BE_VALID_ID);
    }

    public static Defect<Void> validLogin() {
        return new Defect<>(DefectIds.MUST_BE_VALID_LOGIN);
    }

    public static Defect<Void> absentRequiredField() {
        return new Defect<>(DefectIds.ABSENT_REQUIRED_FIELD);
    }

    public static Defect<Void> requiredButEmpty() {
        return new Defect<>(DefectIds.REQUIRED_BUT_EMPTY);
    }

    public static Defect<Void> mustBeEmpty() {
        return new Defect<>(DefectIds.MUST_BE_EMPTY);
    }

    public static Defect<Void> objectNotFound() {
        return new Defect<>(DefectIds.OBJECT_NOT_FOUND);
    }

    public static Defect<Void> unableToDelete() {
        return new Defect<>(DefectIds.UNABLE_TO_DELETE);
    }

    public static Defect<Void> inconsistentState() {
        return new Defect<>(DefectIds.INCONSISTENT_STATE);
    }

    public static Defect<Void> inconsistentStateAlreadyExists() {
        return new Defect<>(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS);
    }

    public static Defect<Void> failedToAcquireLock() {
        return new Defect<>(DefectIds.FAILED_TO_ACQUIRE_LOCK);
    }
}
