package ru.yandex.direct.validation.defect;

import java.time.LocalDate;
import java.time.LocalDateTime;

import ru.yandex.direct.validation.defect.ids.DateDefectIds;
import ru.yandex.direct.validation.defect.ids.DateTimeDefectIds;
import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.defect.params.DateDefectParams;
import ru.yandex.direct.validation.defect.params.DateTimeDefectParams;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class DateDefects {

    public DateDefects() {
    }


    // dates
    public static Defect<NumberDefectParams> notOlderThan(long days) {
        return new Defect<>(NumberDefectIds.MUST_BE_NOT_OLDER, new NumberDefectParams().withMax(days));
    }

    public static Defect<DateDefectParams> greaterThanOrEqualTo(LocalDate min) {
        return new Defect<>(DateDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                new DateDefectParams().withMin(min));
    }

    public static Defect<DateDefectParams> lessThanOrEqualTo(LocalDate max) {
        return new Defect<>(DateDefectIds.MUST_BE_LESS_THAN_OR_EQUAL_TO_MAX,
                new DateDefectParams().withMax(max));
    }

    // times
    public static Defect<DateTimeDefectParams> greaterThan(LocalDateTime min) {
        return new Defect<>(DateTimeDefectIds.MUST_BE_GREATER_THAN_MIN,
                new DateTimeDefectParams().withMin(min));
    }

    public static Defect<DateDefectParams> greaterThan(LocalDate min) {
        return new Defect<>(DateDefectIds.MUST_BE_GREATER_THAN_MIN,
                new DateDefectParams().withMin(min));
    }

    public static Defect<DateDefectParams> endDateMustBeGreatherThanOrEqualToStartDate() {
        return new Defect<>(DateDefectIds.END_DATE_MUST_BE_GREATER_THAN_OR_EQUAL_TO_START_DATE,
                new DateDefectParams());
    }

    /**
     * при считывании истории задан слишком большой временной промежуток,
     * количество изменений в котором превышает максимальный размер выдачи
     */
    public static Defect<DateTimeDefectParams> broadHistoryTimeInterval(LocalDateTime min, LocalDateTime max) {
        return new Defect<>(DateTimeDefectIds.BROAD_HISTORY_TIME_INTERVAL,
                new DateTimeDefectParams()
                        .withMin(min)
                        .withMax(max));
    }
}
