package ru.yandex.direct.validation.defect;

import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectIds;

public class NumberDefects {

    private NumberDefects() {
    }

    //numbers
    public static Defect<Void> isWholeNumber() {
        return new Defect<>(DefectIds.MUST_BE_WHOLE_NUMBER);
    }

    public static Defect<NumberDefectParams> lessThan(Number max) {
        return new Defect<>(NumberDefectIds.MUST_BE_LESS_THEN_MAX,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<NumberDefectParams> lessThanOrEqualTo(Number max) {
        return new Defect<>(NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                new NumberDefectParams().withMax(max));
    }

    public static Defect<NumberDefectParams> greaterThan(Number min) {
        return new Defect<>(NumberDefectIds.MUST_BE_GREATER_THAN_MIN,
                new NumberDefectParams().withMin(min));
    }

    public static Defect<NumberDefectParams> greaterThanOrEqualTo(Number min) {
        return new Defect<>(NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                new NumberDefectParams().withMin(min));
    }

    public static Defect<NumberDefectParams> inInterval(Number min, Number max) {
        return new Defect<>(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE,
                new NumberDefectParams()
                        .withMax(max)
                        .withMin(min));
    }

    public static Defect<NumberDefectParams> inIntervalExcludingBorders(Number min, Number max) {
        return new Defect<>(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS,
                new NumberDefectParams()
                        .withMax(max)
                        .withMin(min));
    }

}
