package ru.yandex.direct.validation.defect;

import java.util.List;

import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.defect.params.StringDefectParams;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectIds;

public class StringDefects {

    private StringDefects() {
    }

    public static Defect<StringDefectParams> admissibleChars() {
        return new Defect<>(StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS);
    }

    public static Defect<Void> mustContainLetters() {
        return new Defect<>(DefectIds.MUST_CONTAIN_LETTERS);
    }

    public static Defect<Void> mustContainLettersOrDigitsOrPunctuations() {
        return new Defect<>(DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS);
    }

    public static Defect<StringDefectParams> mustNotContainsForbiddenSymbols(List<String> forbiddenSymbols) {
        return new Defect<>(StringDefectIds.CANNOT_CONTAIN_SYMBOLS,
                new StringDefectParams().withInvalidSubstrings(forbiddenSymbols));
    }

    public static Defect<StringDefectParams> notEmptyString() {
        return new Defect<>(StringDefectIds.CANNOT_BE_EMPTY);
    }
}
