package ru.yandex.direct.validation.defect.ids;

import ru.yandex.direct.validation.defect.params.CollectionSizeDefectParams;
import ru.yandex.direct.validation.result.DefectId;

public class CollectionDefectIds {
    private CollectionDefectIds() {
    }

    public enum Gen implements DefectId<Void> {
        CANNOT_BE_EMPTY,
        MUST_BE_EMPTY,
        CANNOT_CONTAIN_NULLS,
        MUST_BE_IN_COLLECTION,
        MUST_NOT_BE_IN_COLLECTION,
        MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
        MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
    }

    public enum Size implements DefectId<CollectionSizeDefectParams> {
        INVALID_COLLECTION_SIZE,
        MAX_ELEMENTS_EXCEEDED,
        MAX_ELEMENTS_PER_REQUEST,
        SIZE_CANNOT_BE_LESS_THAN_MIN,
        SIZE_CANNOT_BE_MORE_THAN_MAX,
        SIZE_MUST_BE_IN_INTERVAL,
    }

}
