package ru.yandex.direct.validation.defect.params;

public class CollectionSizeDefectParams {
    private Integer maxSize;
    private Integer minSize;

    public Integer getMaxSize() {
        return maxSize;
    }

    public CollectionSizeDefectParams withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Integer getMinSize() {
        return minSize;
    }

    public CollectionSizeDefectParams withMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    @Override
    public String toString() {
        return "CollectionSizeDefectParams{" +
                "maxSize=" + maxSize +
                ", minSize=" + minSize +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CollectionSizeDefectParams that = (CollectionSizeDefectParams) o;

        if (maxSize != null ? !maxSize.equals(that.maxSize) : that.maxSize != null) {
            return false;
        }
        return minSize != null ? minSize.equals(that.minSize) : that.minSize == null;
    }

    @Override
    public int hashCode() {
        int result = maxSize != null ? maxSize.hashCode() : 0;
        result = 31 * result + (minSize != null ? minSize.hashCode() : 0);
        return result;
    }

}
