package ru.yandex.direct.validation.defect.params;

import java.time.LocalDate;

public class DateDefectParams {
    private LocalDate min;
    private LocalDate max;

    public LocalDate getMax() {
        return max;
    }

    public DateDefectParams withMax(LocalDate max) {
        this.max = max;
        return this;
    }

    public LocalDate getMin() {
        return min;
    }

    public DateDefectParams withMin(LocalDate min) {
        this.min = min;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        DateDefectParams that = (DateDefectParams) o;

        if (min != null ? !min.equals(that.min) : that.min != null) {
            return false;
        }
        return max != null ? max.equals(that.max) : that.max == null;
    }

    @Override
    public int hashCode() {
        int result = min != null ? min.hashCode() : 0;
        result = 31 * result + (max != null ? max.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "LocalDateDefectParams{" +
                "min=" + min +
                ", max=" + max +
                '}';
    }
}
