package ru.yandex.direct.validation.defect.params;

import java.time.LocalDateTime;
import java.util.Objects;

public class DateTimeDefectParams {

    private LocalDateTime min;
    private LocalDateTime max;
    private LocalDateTime expectedValue;

    public LocalDateTime getMin() {
        return min;
    }

    public DateTimeDefectParams withMin(LocalDateTime min) {
        this.min = min;
        return this;
    }

    public LocalDateTime getMax() {
        return max;
    }

    public DateTimeDefectParams withMax(LocalDateTime max) {
        this.max = max;
        return this;
    }

    public LocalDateTime getExpectedValue() {
        return expectedValue;
    }

    public DateTimeDefectParams withExpectedValue(LocalDateTime expectedValue) {
        this.expectedValue = expectedValue;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DateTimeDefectParams that = (DateTimeDefectParams) o;
        return Objects.equals(min, that.min) &&
                Objects.equals(max, that.max) &&
                Objects.equals(expectedValue, that.expectedValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(min, max, expectedValue);
    }

    @Override
    public String toString() {
        return "DateTimeDefectParams{" +
                "min=" + min +
                ", max=" + max +
                ", expectedValue=" + expectedValue +
                '}';
    }
}
