package ru.yandex.direct.validation.defect.params;

public class NumberDefectParams {
    private Number max;
    private Number min;

    public Number getMax() {
        return max;
    }

    public NumberDefectParams withMax(Number max) {
        this.max = max;
        return this;
    }

    public Number getMin() {
        return min;
    }

    public NumberDefectParams withMin(Number min) {
        this.min = min;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        NumberDefectParams that = (NumberDefectParams) o;

        if (max != null ? !max.equals(that.max) : that.max != null) {
            return false;
        }
        return min != null ? min.equals(that.min) : that.min == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (max != null ? max.hashCode() : 0);
        result = 31 * result + (min != null ? min.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "NumberDefectParams{" +
                "max=" + max +
                ", min=" + min +
                '}';
    }
}
