package ru.yandex.direct.validation.defect.params;

import java.util.Collections;
import java.util.List;

public class StringDefectParams {
    private Integer maxLength;
    private Integer minLength;
    private Integer maxWords;
    private List<String> invalidSubstrings;
    private static final String DEFAULT_SEPARATOR = ", ";

    public Integer getMaxLength() {
        return maxLength;
    }

    public StringDefectParams withMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return minLength;
    }

    public StringDefectParams withMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public StringDefectParams withInvalidSubstrings(List<String> substrings) {
        this.invalidSubstrings = substrings;
        return this;
    }

    public String getAllInvalidSubstrings() {
        return getAllInvalidSubstrings(DEFAULT_SEPARATOR);
    }

    public String getAllInvalidSubstrings(String separator) {
        return invalidSubstrings == null
                ? null
                : String.join(separator, invalidSubstrings);
    }

    public Integer getMaxWords() {
        return maxWords;
    }

    public StringDefectParams withMaxWords(int maxWords) {
        this.maxWords = maxWords;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StringDefectParams that = (StringDefectParams) o;

        if (maxLength != null ? !maxLength.equals(that.maxLength) : that.maxLength != null) {
            return false;
        }
        if (minLength != null ? !minLength.equals(that.minLength) : that.minLength != null) {
            return false;
        }
        if (maxWords != null ? !maxWords.equals(that.maxWords) : that.maxWords != null) {
            return false;
        }
        if (invalidSubstrings != null
                ? !invalidSubstrings.equals(that.invalidSubstrings == null
                ? Collections.emptyList() : that.invalidSubstrings)
                : !(that.invalidSubstrings == null || that.invalidSubstrings.isEmpty())) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = maxLength != null ? maxLength.hashCode() : 0;
        result = 31 * result + (minLength != null ? minLength.hashCode() : 0);
        result = 31 * result + (maxWords != null ? maxWords.hashCode() : 0);
        result = 31 * result + (invalidSubstrings != null ? invalidSubstrings.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "StringDefectParams{" +
                "maxLength=" + String.valueOf(maxLength) +
                ", minLength=" + String.valueOf(minLength) +
                ", maxWords=" + String.valueOf(maxWords) +
                ", invalidSubstrings=" + String.valueOf(getAllInvalidSubstrings()) +
                '}';
    }
}
