package ru.yandex.direct.validation.presentation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

/**
 * Превращает ядровый дефект в его представление для внешнего интерфейса.
 *
 * @param <T> тип параметров дефекта ({@link Defect}).
 * @param <P> тип представления дефекта.
 */
@FunctionalInterface
@ParametersAreNonnullByDefault
public interface DefectPresentationProvider<T, P> {

    P getPresentation(DefectInfo<? extends Defect<T>> defectInfo);
}
