package ru.yandex.direct.validation.presentation;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;
import ru.yandex.direct.validation.result.DefectInfo;

/**
 * Реестр, позволяющий получить представление дефекта по {@link DefectInfo}
 * для дефектов типа {@link Defect}.
 * <p>
 * Базируется на том принципе, что {@link Defect} содержит
 * {@link DefectId}, который служит идентификатором для линковки ядровых дефектов
 * к провайдерам их представлений - {@link DefectPresentationProvider}.
 *
 * @param <P> тип представления дефекта.
 */
@ParametersAreNonnullByDefault
public interface DefectPresentationRegistry<P> {

    P getPresentation(DefectInfo<? extends Defect> defectInfo);

    Set<DefectId<?>> getRegisteredDefectIds();
}
