package ru.yandex.direct.validation.result;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

/**
 * Базовое описание дефекта. Содержит в себе DefectId - является ключом,
 * по которому будет выбрана необходимая презентация
 *
 * @param <T> тип параметров дефекта
 */
// Иногда полезно вывести в toJson() результат валидации (например, во внутренних отчётах)
// но по умолчанию сериализатор такой объект обработать не сможет -- будет ругаться на FAIL_ON_EMPTY_BEANS
// В этом месте нас спасёт toString()
@JsonSerialize(using = ToStringSerializer.class)
public class Defect<T> {
    private final DefectId<T> defectId;
    private final T params;

    public Defect(@Nonnull DefectId<T> defectId) {
        this.defectId = defectId;
        this.params = null;
    }

    public Defect(@Nonnull DefectId<T> defectId, T params) {
        this.defectId = defectId;
        this.params = params;
    }

    public DefectId<T> defectId() {
        return defectId;
    }

    public T params() {
        return params;
    }

    @Override
    @SuppressWarnings({"ConstantConditions", "SimplifiableIfStatement"})
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Defect<?> that = (Defect<?>) o;

        if (defectId != null ? !defectId.equals(that.defectId) : that.defectId != null) {
            return false;
        }
        return params != null ? params.equals(that.params) : that.params == null;
    }

    @SuppressWarnings({"ConstantConditions"})
    @Override
    public int hashCode() {
        int result = defectId != null ? defectId.hashCode() : 0;
        result = 31 * result + (params != null ? params.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Defect{" +
                "defectId=" + defectId +
                ", params=" + params +
                '}';
    }
}
