package ru.yandex.direct.validation.result;

/**
 * Информация об ошибке/предупреждении.
 * Содержит экземпляр "дефекта" произвольного типа, путь к полю,
 * на котором он найден, а так же валидируемое значение.
 *
 * @param <D> тип "дефекта"
 */
public class DefectInfo<D> {
    private final Path path;
    private final Object value;
    private final D defect;

    public DefectInfo(Path path, Object value, D defect) {
        this.path = path;
        this.value = value;
        this.defect = defect;
    }

    public Path getPath() {
        return path;
    }

    public Object getValue() {
        return value;
    }

    public D getDefect() {
        return defect;
    }

    public DefectInfo<D> convertPath(PathConverter pathConverter) {
        return new DefectInfo<>(
                pathConverter.convert(getPath()),
                getValue(),
                getDefect());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefectInfo)) {
            return false;
        }

        DefectInfo<?> that = (DefectInfo<?>) o;

        if (!path.equals(that.path)) {
            return false;
        }
        if (value != null ? !value.equals(that.value) : that.value != null) {
            return false;
        }
        return defect.equals(that.defect);
    }

    @Override
    public int hashCode() {
        int result = path.hashCode();
        result = 31 * result + (value != null ? value.hashCode() : 0);
        result = 31 * result + defect.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "DefectInfo{" +
                "path=" + path +
                ", defect=" + defect +
                ", value=" + value +
                '}';
    }
}
