package ru.yandex.direct.validation.result;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Конвертирует {@link Path}.
 */
@FunctionalInterface
@ParametersAreNonnullByDefault
public interface PathConverter {
    @Nonnull
    Path convert(Path source);

    static PathConverter identity() {
        return p -> p;
    }

    static PathConverter prepend(Path prefix) {
        return p -> PathHelper.concat(prefix, p);
    }
}
