package ru.yandex.direct.validation.util;

import java.util.List;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.ValidationResult;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

public class ConstraintsValidator<T, D> implements Validator<T, D> {

    private final List<Constraint<T, D>> constraints;

    private ConstraintsValidator(List<Constraint<T, D>> constraints) {
        this.constraints = constraints;
    }

    public static <T, D> ConstraintsValidator<T, D> constraintsValidator(List<Constraint<T, D>> constraints) {
        return new ConstraintsValidator<>(constraints);
    }

    public static <T, D> ConstraintsValidator<T, D> oneConstraintValidator(Constraint<T, D> constraint) {
        return new ConstraintsValidator<>(singletonList(constraint));
    }

    public static <T, D> ConstraintsValidator<T, D> emptyValidator() {
        return new ConstraintsValidator<>(emptyList());
    }

    @Override
    public ValidationResult<T, D> apply(T t) {
        ItemValidationBuilder<T, D> itemValidationBuilder = ItemValidationBuilder.of(t);

        constraints.forEach(itemValidationBuilder::check);

        return itemValidationBuilder.getResult();
    }
}
