package ru.yandex.direct.validation.wrapper;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.PathHelper;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;


/**
 * @param <M>
 */
@ParametersAreNonnullByDefault
public class ModelItemValidationBuilder<M extends Model> extends ItemValidationBuilder<M, Defect> {

    public ModelItemValidationBuilder(ValidationResult<M, Defect> validationResult) {
        super(validationResult);
    }

    public static <T extends Model> ModelItemValidationBuilder<T> of(@Nullable T item) {
        return new ModelItemValidationBuilder<>(new ValidationResult<>(item));
    }

    private static <V, M extends Model> V getNullableProperty(@Nullable M model, ModelProperty<M, V> prop) {
        if (model == null) {
            throw new IllegalArgumentException("attempt to get property of null model");
        }
        return prop.get(model);
    }

    public <V> ItemValidationBuilder<V, Defect> item(ModelProperty<? super M, V> prop) {
        V value = getNullableProperty(getResult().getValue(), prop);
        PathNode.Field path = PathHelper.field(prop.name());
        return new ItemValidationBuilder<>(getResult().getOrCreateSubValidationResult(path, value));
    }

    public <V extends Model> ModelItemValidationBuilder<V> modelItem(ModelProperty<? super M, V> prop) {
        V value = getNullableProperty(getResult().getValue(), prop);
        PathNode.Field path = PathHelper.field(prop.name());
        return new ModelItemValidationBuilder<>(getResult().getOrCreateSubValidationResult(path, value));
    }

    public <I> ListValidationBuilder<I, Defect> list(ModelProperty<? super M, List<I>> prop) {
        List<I> value = getNullableProperty(getResult().getValue(), prop);
        PathNode.Field path = PathHelper.field(prop.name());
        return new ListValidationBuilder<>(getResult().getOrCreateSubValidationResult(path, value));
    }
}
