package ru.yandex.direct.libs.video;

import java.time.Duration;

public class VideoClientConfig {
    private final String baseUrl;
    private final int requestRetries;
    private final Duration softTimeout;
    private final Duration requestTimeout;
    private final int parallel;

    public VideoClientConfig(String baseUrl, int requestRetries, Duration softTimeout, Duration requestTimeout,
                             int parallel) {
        this.baseUrl = baseUrl;
        this.requestRetries = requestRetries;
        this.softTimeout = softTimeout;
        this.requestTimeout = requestTimeout;
        this.parallel = parallel;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public int getRequestRetries() {
        return requestRetries;
    }

    public Duration getRequestTimeout() {
        return requestTimeout;
    }

    public int getParallel() {
        return parallel;
    }

    public Duration getSoftTimeout() {
        return softTimeout;
    }
}
