package ru.yandex.direct.libs.video.model;

import java.nio.charset.Charset;
import java.time.OffsetDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import ru.yandex.direct.utils.HashingUtils;

import static ru.yandex.direct.libs.video.Constants.DATETIME_FORMAT;
import static ru.yandex.direct.utils.JsonUtils.toJson;

@JsonPropertyOrder(alphabetic = true)
public class Clip {
    // Пропущены поля:
    // ans_type
    // episode_query
    // factors
    // global_img_id
    // HtmlAutoplayVideoPlayer
    // HtmlVideoPlayer
    // IsPornoDoc
    // PlayerParams
    // rvq_query
    // rvq_query_exp
    // vmusicalbtitle
    // vmusicalbumid
    // vmusicalbyear
    // vmusiclyrartist
    // vmusiclyrtrack
    // vmusictrackid
    // vthumb_src
    // vtop

    @JsonProperty("_factors")
    private Object factors;

    @JsonProperty("_markers")
    private List<String> markers;

    @JsonProperty("ads")
    private Object ads;

    @JsonProperty("authorid")
    private String authorId;

    @JsonProperty("authorname")
    private Object authorName;

    @JsonProperty("BanDescription")
    private Object banDescription;

    @JsonProperty("basehost")
    private String baseHost;

    @JsonProperty("category")
    private Object category;

    @JsonProperty("cdt")
    @JsonFormat(pattern = DATETIME_FORMAT)
    private OffsetDateTime cdt;

    @JsonProperty("clear_title")
    private String clearTitle;

    @JsonProperty("clip_host")
    private String clipHost;

    @JsonProperty("clip_href")
    private String clipHref;

    @JsonProperty("collections_favorites")
    private Object collectionsFavorites;

    @JsonProperty("crc")
    private String crc;

    @JsonProperty("detail_url")
    private String detailUrl;

    @JsonProperty("docid")
    private String docId;

    @JsonProperty("dur")
    private String dur;

    @JsonProperty("duration")
    private Integer duration;

    @JsonProperty("embed")
    private String embed;

    @JsonProperty("emoji")
    private String emoji;

    @JsonProperty("episode")
    private Object episode;

    @JsonProperty("extra")
    private ExtraInfo extra;

    @JsonProperty("frames")
    private Frames frames;

    @JsonProperty("green_host")
    private String greenHost;

    @JsonProperty("group_id")
    private String groupId;

    @JsonProperty("group_name")
    private String groupName;

    @JsonProperty("group_relevance")
    private String groupRelevance;

    @JsonProperty("group_size")
    private Long groupSize;

    @JsonProperty("Host")
    private String host;

    @JsonProperty("hst")
    private String hst;

    @JsonProperty("html5")
    private String html5;

    @JsonProperty("html_href")
    private String htmlHref;

    @JsonProperty("img_h")
    private String imgH;

    @JsonProperty("img_href")
    private String imgHref;

    @JsonProperty("img_w")
    private String imgW;

    @JsonProperty("is_new24")
    private String isNew24;

    @JsonProperty("is_vdv")
    private Object isVdv;

    @JsonProperty("metahosts")
    private List<String> metahosts;

    @JsonProperty("middle_color")
    private Object middleColor;

    @JsonProperty("mtime")
    @JsonFormat(pattern = DATETIME_FORMAT)
    private OffsetDateTime mtime;

    @JsonProperty("nid")
    private String nid;

    @JsonProperty("onecolor")
    private Object oneColor;

    @JsonProperty("pass")
    private String pass;

    @JsonProperty("PlayerId")
    private String playerId;

    @JsonProperty("players")
    private Players players;

    @JsonProperty("previews")
    private List<Preview> previews;

    @JsonProperty("rating")
    private Object rating;

    @JsonProperty("raw_pass")
    private String rawPass;

    @JsonProperty("raw_title")
    private String rawTitle;

    @JsonProperty("relevance")
    private Long relevance;

    @JsonProperty("RTBF")
    private Object rtbf;

    @JsonProperty("rvb")
    private String rvb;

    @JsonProperty("rvq")
    private String rvq;

    @JsonProperty("search_info")
    private Object searchInfo;

    @JsonProperty("season")
    private Object season;

    @JsonProperty("serial")
    private Object serial;

    @JsonProperty("sertitle")
    private Object sertitle;

    @JsonProperty("server_descr")
    private String serverDescr;

    @JsonProperty("src")
    private String src;

    @JsonProperty("taas")
    private String taas;

    @JsonProperty("tasix")
    private Object tasix;

    @JsonProperty("thmb_h")
    private String thmbH;

    @JsonProperty("thmb_h_orig")
    private String thmbHOrig;

    @JsonProperty("thmb_href")
    private String thmbHref;

    @JsonProperty("thmb_w")
    private String thmbW;

    @JsonProperty("thmb_w_orig")
    private String thmbWOrig;

    @JsonProperty("thumb")
    private String thumb;

    @JsonProperty("thumbs")
    private Thumbs thumbs;

    @JsonProperty("title")
    private String title;

    @JsonProperty("UgcScenario")
    private Object ugcScenario;

    @JsonProperty("url")
    private String url;

    @JsonProperty("v1080hd")
    private String v1080hd;

    @JsonProperty("valt")
    private Object valt;

    @JsonProperty("vc")
    private Object vc;

    @JsonProperty("vcclickpixel")
    private Object vcClickPixel;

    @JsonProperty("vcshowpixel")
    private Object vcShowPixel;

    @JsonProperty("vdeephd")
    private Object vDeepHd;

    @JsonProperty("vdv_progress")
    private Object vdvProgress;

    @JsonProperty("vhd")
    private String vHd;

    @JsonProperty("vhdbin")
    private String vhdbin;

    @JsonProperty("videoid")
    private String videoId;

    @JsonProperty("VideoObjects")
    private Object videoObjects;

    @JsonProperty("views")
    private Integer views;

    @JsonProperty("VisibleHost")
    private String visibleHost;

    @JsonProperty("VisibleURL")
    private String visibleUrl;

    @JsonProperty("vmusicartist")
    private Object vMusicArtist;

    @JsonProperty("vmusicartistid")
    private Object vMusicArtistId;

    @JsonProperty("vmusiclyrauthor")
    private Object vMusicLyrAuthor;

    @JsonProperty("vmusiclyrics")
    private Object vMusicLyrics;

    @JsonProperty("vmusiclyrurls")
    private Object vMusicLyrUrls;

    @JsonProperty("vmusictrack")
    private Object vMusicTrack;

    @JsonProperty("VoiceoverLang")
    private Object voiceoverLang;

    @JsonProperty("VoiceoverStudio")
    private Object voiceoverStudio;

    @JsonProperty("vtags")
    private Object vtags;

    public List<String> getMarkers() {
        return markers;
    }

    public Clip setMarkers(List<String> markers) {
        this.markers = markers;
        return this;
    }

    public String getRawPass() {
        return rawPass;
    }

    public Clip setRawPass(String rawPass) {
        this.rawPass = rawPass;
        return this;
    }

    public String getRawTitle() {
        return rawTitle;
    }

    public Clip setRawTitle(String rawTitle) {
        this.rawTitle = rawTitle;
        return this;
    }

    public String getThmbHref() {
        return thmbHref;
    }

    public Clip setThmbHref(String thmbHref) {
        this.thmbHref = thmbHref;
        return this;
    }

    @JsonIgnore
    public Long getMd5HalfHash() {
        return HashingUtils.getMd5HalfHash(toJson(this).getBytes(Charset.forName("UTF-8"))).longValue();
    }
}
