package ru.yandex.direct.libs.video.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;

import ru.yandex.direct.libs.video.VideoClientUtils;

import static com.google.common.base.Preconditions.checkState;
import static java.util.function.Function.identity;
import static org.apache.commons.lang3.StringUtils.isEmpty;

@JsonPropertyOrder(alphabetic = true)
public class VideoBanner {
    public static final String JSON_PATH = "search.context.data.Grouping.[0].Group";

    private static final ImmutableSet<String> blackList =
            ImmutableSet.of("_Markers", "_MetaSearcherHostname", "_SerpData", "emoji");

    @JsonProperty("Charset")
    private String charset;

    @JsonProperty("AnsType")
    private String ansType;

    @JsonProperty("ClipsProperties")
    private String clipsProperties;

    @JsonProperty("Host")
    private String host;

    @JsonProperty("HostingId")
    private String hostingId;

    @JsonProperty("HtmlAutoplayVideoPlayer")
    private String htmlAutoplayVideoPlayer;

    @JsonProperty("HtmlVideoPlayer")
    private String htmlVideoPlayer;

    @JsonProperty("MediaDuration")
    private String mediaDuration;

    @JsonProperty("PlayerId")
    private String playerId;

    @JsonProperty("PlayerParams")
    private String playerParams;

    @JsonProperty("VisibleHost")
    private String visibleHost;

    @JsonProperty("VisibleURL")
    private String visibleUrl;

    @JsonProperty("_SearcherHostname")
    private String searcherHostname;

    @JsonProperty("authorid")
    private String authorId;

    @JsonProperty("cmnt_id")
    private String cmntId;

    @JsonProperty("frames")
    private String frames;

    @JsonProperty("online")
    private String online;

    @JsonProperty("previews")
    private String previews;

    @JsonProperty("rvb")
    private String rvb;

    @JsonProperty("thattrs")
    private String thAttrs;

    @JsonProperty("thmb_href")
    private String thmbHref;

    @JsonProperty("v1080hd")
    private String v1080hd;

    @JsonProperty("vhd")
    private String vhd;

    @JsonProperty("vhdbin")
    private String vhdbin;

    @JsonProperty("videoid")
    private String videoId;

    @JsonProperty("vthumb")
    private String vthumb;

    @JsonProperty("_MimeType")
    private String mimeType;

    @JsonProperty("Passage")
    private List<String> passage;

    @JsonProperty("Title")
    private String title;

    @JsonProperty("Url")
    private String url;

    public String getCharset() {
        return charset;
    }

    public VideoBanner setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getAnsType() {
        return ansType;
    }

    public VideoBanner setAnsType(String ansType) {
        this.ansType = ansType;
        return this;
    }

    public String getClipsProperties() {
        return clipsProperties;
    }

    public VideoBanner setClipsProperties(String clipsProperties) {
        this.clipsProperties = clipsProperties;
        return this;
    }

    public String getHost() {
        return host;
    }

    public VideoBanner setHost(String host) {
        this.host = host;
        return this;
    }

    public String getHostingId() {
        return hostingId;
    }

    public VideoBanner setHostingId(String hostingId) {
        this.hostingId = hostingId;
        return this;
    }

    public String getHtmlAutoplayVideoPlayer() {
        return htmlAutoplayVideoPlayer;
    }

    public VideoBanner setHtmlAutoplayVideoPlayer(String htmlAutoplayVideoPlayer) {
        this.htmlAutoplayVideoPlayer = htmlAutoplayVideoPlayer;
        return this;
    }

    public String getHtmlVideoPlayer() {
        return htmlVideoPlayer;
    }

    public VideoBanner setHtmlVideoPlayer(String htmlVideoPlayer) {
        this.htmlVideoPlayer = htmlVideoPlayer;
        return this;
    }

    public String getMediaDuration() {
        return mediaDuration;
    }

    public VideoBanner setMediaDuration(String mediaDuration) {
        this.mediaDuration = mediaDuration;
        return this;
    }

    public String getPlayerId() {
        return playerId;
    }

    public VideoBanner setPlayerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    public String getPlayerParams() {
        return playerParams;
    }

    public VideoBanner setPlayerParams(String playerParams) {
        this.playerParams = playerParams;
        return this;
    }

    public String getVisibleHost() {
        return visibleHost;
    }

    public VideoBanner setVisibleHost(String visibleHost) {
        this.visibleHost = visibleHost;
        return this;
    }

    public String getVisibleUrl() {
        return visibleUrl;
    }

    public VideoBanner setVisibleUrl(String visibleUrl) {
        this.visibleUrl = visibleUrl;
        return this;
    }

    public String getSearcherHostname() {
        return searcherHostname;
    }

    public VideoBanner setSearcherHostname(String searcherHostname) {
        this.searcherHostname = searcherHostname;
        return this;
    }

    public String getAuthorId() {
        return authorId;
    }

    public VideoBanner setAuthorId(String authorId) {
        this.authorId = authorId;
        return this;
    }

    public String getCmntId() {
        return cmntId;
    }

    public VideoBanner setCmntId(String cmntId) {
        this.cmntId = cmntId;
        return this;
    }

    public String getFrames() {
        return frames;
    }

    public VideoBanner setFrames(String frames) {
        this.frames = frames;
        return this;
    }

    public String getOnline() {
        return online;
    }

    public VideoBanner setOnline(String online) {
        this.online = online;
        return this;
    }

    public String getPreviews() {
        return previews;
    }

    public VideoBanner setPreviews(String previews) {
        this.previews = previews;
        return this;
    }

    public String getRvb() {
        return rvb;
    }

    public VideoBanner setRvb(String rvb) {
        this.rvb = rvb;
        return this;
    }

    public String getThAttrs() {
        return thAttrs;
    }

    public VideoBanner setThAttrs(String thAttrs) {
        this.thAttrs = thAttrs;
        return this;
    }

    public String getThmbHref() {
        return thmbHref;
    }

    public VideoBanner setThmbHref(String thmbHref) {
        this.thmbHref = thmbHref;
        return this;
    }

    public String getV1080hd() {
        return v1080hd;
    }

    public VideoBanner setV1080hd(String v1080hd) {
        this.v1080hd = v1080hd;
        return this;
    }

    public String getVhd() {
        return vhd;
    }

    public VideoBanner setVhd(String vhd) {
        this.vhd = vhd;
        return this;
    }

    public String getVhdbin() {
        return vhdbin;
    }

    public VideoBanner setVhdbin(String vhdbin) {
        this.vhdbin = vhdbin;
        return this;
    }

    public String getVideoId() {
        return videoId;
    }

    public VideoBanner setVideoId(String videoId) {
        this.videoId = videoId;
        return this;
    }

    public String getVthumb() {
        return vthumb;
    }

    public VideoBanner setVthumb(String vthumb) {
        this.vthumb = vthumb;
        return this;
    }

    public String getMimeType() {
        return mimeType;
    }

    public VideoBanner setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public List<String> getPassage() {
        return passage;
    }

    public VideoBanner setPassage(List<String> passage) {
        this.passage = passage;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public VideoBanner setTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * <b>Attention</b>. Если хочешь использовать этот метод, возможно, вместо него надо использовать
     * {@link VideoClientUtils#getUniformUrl(VideoBanner)} для поддержки URL из Я.Эфира.
     */
    public String getUrl() {
        return url;
    }

    public VideoBanner setUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Превращает разобранный в Map&lt;String, Object&gt; JSON в коллекцию объектов VideoBanner. Такой хитрый разбор,
     * так как у нас пока нет стабильного фиксированного API, мы ходим в обычный поиск Яндекс-Видео со специальным
     * дебаг-параметром json_dump. Этот параметр заставляет поиск дампить результаты в JSON, и доступен только из
     * внутренней сети. У этого JSON дампа формат не фиксирован, даже не ясно, какие поля обязательные.
     * @param parsedJson мапа строка - объект, а-ля перловый хэш, содержащая распарсенный JSON
     * @return мапа "url баннера" - "баннер"
     */
    @SuppressWarnings("unchecked")
    public static Map<String, VideoBanner> parseBannerCollectionJson(Object parsedJson) {
        checkMetaFormat(parsedJson);

        Optional<List<Map<String, Object>>> data = Optional.ofNullable(parsedJson)
                .map(pj -> (Map<String, Object>) pj)
                .map(rootJson -> (List<Map<String, Object>>) rootJson.get(JSON_PATH));

        if (data.isEmpty()) {
            return Map.of();
        }

        return StreamEx.of(data.get())
                .map(group -> group.get("Document"))
                .flatMap(documentList -> ((List<Object>) documentList).stream())
                .map(document -> ((Map<String, Object>)document).get("ArchiveInfo"))
                .nonNull()
                .map(VideoBanner::parseBannerJson)
                .filter(banner -> !isEmpty(banner.url))
                .toMap(VideoClientUtils::getUniformUrl, identity());
    }

    /**
     * Проверяет правильность формата метаданных видео
     */
    public static void checkMetaFormat(Object parsedJson) {
        if (parsedJson == null) {
            return;
        }

        Map<String, Object> rootJson = (Map<String, Object>) parsedJson;

        checkState(rootJson.get(JSON_PATH) != null, "Content promotion video meta has incorrect format");
    }

    @SuppressWarnings("unchecked")
    private static VideoBanner parseBannerJson(Object parsedJson) {
        Map<String, Object> data = (Map<String, Object>) parsedJson;

        Map<String, String> gtaRelatedAttributes = StreamEx.of((List<Object>) data.get("GtaRelatedAttribute"))
                .select(Map.class)
                .filter(attr -> !blackList.contains(attr.get("Key")))
                .toMap(attr -> (String) attr.get("Key"),
                        attr -> (String) attr.get("Value"),
                        (val1, val2) -> val1);

        return new VideoBanner()
                .setCharset((String) data.get("Charset"))
                .setAnsType(gtaRelatedAttributes.get("AnsType"))
                .setClipsProperties(gtaRelatedAttributes.get("ClipsProperties"))
                .setHost(gtaRelatedAttributes.get("Host"))
                .setHostingId(gtaRelatedAttributes.get("HostingId"))
                .setHtmlAutoplayVideoPlayer(gtaRelatedAttributes.get("HtmlAutoplayVideoPlayer"))
                .setHtmlVideoPlayer(gtaRelatedAttributes.get("HtmlVideoPlayer"))
                .setMediaDuration(gtaRelatedAttributes.get("MediaDuration"))
                .setPlayerId(gtaRelatedAttributes.get("PlayerId"))
                .setPlayerParams(gtaRelatedAttributes.get("PlayerParams"))
                .setVisibleHost(gtaRelatedAttributes.get("VisibleHost"))
                .setVisibleUrl(gtaRelatedAttributes.get("VisibleURL"))
                .setSearcherHostname(gtaRelatedAttributes.get("_SearcherHostname"))
                .setAuthorId(gtaRelatedAttributes.get("authorid"))
                .setCmntId(gtaRelatedAttributes.get("cmnt_id"))
                .setFrames(gtaRelatedAttributes.get("frames"))
                .setOnline(gtaRelatedAttributes.get("online"))
                .setPreviews(gtaRelatedAttributes.get("previews"))
                .setRvb(gtaRelatedAttributes.get("rvb"))
                .setThAttrs(gtaRelatedAttributes.get("thattrs"))
                .setThmbHref(gtaRelatedAttributes.get("thmb_href"))
                .setV1080hd(gtaRelatedAttributes.get("v1080hd"))
                .setVhd(gtaRelatedAttributes.get("vhd"))
                .setVhdbin(gtaRelatedAttributes.get("vhdbin"))
                .setVideoId(gtaRelatedAttributes.get("videoid"))
                .setVthumb(gtaRelatedAttributes.get("vthumb"))
                .setMimeType(gtaRelatedAttributes.get("_MimeType"))
                .setPassage((List<String>) data.get("Passage"))
                .setTitle((String) data.get("Title"))
                .setUrl((String) data.get("Url"));
    }

    @Override
    public String toString() {
        return "VideoBanner{" +
                "charset='" + charset + '\'' +
                ", ansType='" + ansType + '\'' +
                ", clipsProperties='" + clipsProperties + '\'' +
                ", host='" + host + '\'' +
                ", hostingId='" + hostingId + '\'' +
                ", htmlAutoplayVideoPlayer='" + htmlAutoplayVideoPlayer + '\'' +
                ", htmlVideoPlayer='" + htmlVideoPlayer + '\'' +
                ", mediaDuration='" + mediaDuration + '\'' +
                ", playerId='" + playerId + '\'' +
                ", playerParams='" + playerParams + '\'' +
                ", visibleHost='" + visibleHost + '\'' +
                ", visibleUrl='" + visibleUrl + '\'' +
                ", searcherHostname='" + searcherHostname + '\'' +
                ", authorId='" + authorId + '\'' +
                ", cmntId='" + cmntId + '\'' +
                ", frames='" + frames + '\'' +
                ", online='" + online + '\'' +
                ", previews='" + previews + '\'' +
                ", rvb='" + rvb + '\'' +
                ", thAttrs='" + thAttrs + '\'' +
                ", thmbHref='" + thmbHref + '\'' +
                ", v1080hd='" + v1080hd + '\'' +
                ", vhd='" + vhd + '\'' +
                ", vhdbin='" + vhdbin + '\'' +
                ", videoId='" + videoId + '\'' +
                ", vthumb='" + vthumb + '\'' +
                ", mimeType='" + mimeType + '\'' +
                ", passage=" + passage +
                ", title='" + title + '\'' +
                ", url='" + url + '\'' +
                '}';
    }
}
