package ru.yandex.direct.xiva.client;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.QueryMap;
import ru.yandex.direct.xiva.client.model.BatchPush;
import ru.yandex.direct.xiva.client.model.Push;
import ru.yandex.direct.xiva.client.model.SendBatchResponse;
import ru.yandex.direct.xiva.client.model.Signature;
import ru.yandex.direct.xiva.client.model.SubscribeResponse;
import ru.yandex.direct.xiva.client.model.Subscription;

public interface Api {
    @GET("/v2/secret_sign")
    @Json
    Call<Signature> getSignature(
            @QueryMap Map<String, String> params
    );


    @POST("/v2/send")
    Call<String> send(
            @QueryMap Map<String, String> params,
            @Body @Json Push body
    );

    @POST("/v2/batch_send")
    @Json
    Call<SendBatchResponse> sendBatch(
            @QueryMap Map<String, String> params,
            @Body @Json BatchPush body
    );

    @GET("/v2/list")
    @Json
    Call<List<Subscription>> getSubscriptions(
            @QueryMap Map<String, String> params
    );

    @POST("/v2/subscribe/{type}")
    @Json
    @Headers({"Content-Type: application/x-www-form-urlencoded"})
    Call<SubscribeResponse> subscribe(
            @Path("type") String type,
            @QueryMap Map<String, String> params,
            @Body String body
    );

    @POST("/v2/unsubscribe/{type}")
    Call<String> unsubscribe(
            @Path("type") String type,
            @QueryMap Map<String, String> params
    );
}
