package ru.yandex.direct.xiva.client.model;

/**
 * Описание мобильного приложения для подписки на уведомления.
 * */
public class AppInfo {
    private final String user;
    private final String client;
    private final String uuid;
    private final String device;
    private final String platform;
    private final String appName;

    /**
     * Создать описание приложения.
     *
     * @param user идентификатор пользователя.
     * @param client произвольное название семейства клиентов.
     * @param uuid уникальный идентификатор инсталляции приложения.
     * @param device уникальный идентификатор мобильного устройства (например, device ID мобильной метрики).
     * @param platform мобильная платформа, именуется по названиям пуш сервисов.
     *                 Допустимые значения: apns, fcm, hms, mpns, wns
     * @param appName имя приложения, отображаемое в разделе Сервисы.
     * */
    public AppInfo(String user, String client, String uuid, String device, String platform, String appName) {
        this.user = user;
        this.client = client;
        this.uuid = uuid;
        this.device = device;
        this.platform = platform;
        this.appName = appName;
    }

    public String getUser() {
        return user;
    }

    public String getClient() {
        return client;
    }

    public String getUuid() {
        return uuid;
    }

    public String getDevice() {
        return device;
    }

    public String getPlatform() {
        return platform;
    }

    public String getAppName() {
        return appName;
    }
}
