package ru.yandex.direct.xiva.client.model;

import java.util.LinkedList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Уведомление, посылаемое нескольким пользователям.
 * Используется для генерации тела запроса к Xiva-серверу.
 * */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BatchPush {
    @JsonProperty("recipients")
    private List<Object> recipients = new LinkedList<>();

    @JsonProperty("payload")
    private String payload;

    @JsonProperty("tags")
    private String tags;

    @JsonProperty("keys")
    private String keys;

    @JsonProperty("repack")
    private String repack;

    @JsonProperty("experiments")
    private String experiments;

    @JsonProperty("subscriptions")
    private String subscriptions;

    /**
     * Создать уведомление.
     *
     * @param push само уведомление.
     * @param recipients спико получателей.
     * */
    public BatchPush(Push push, List<Recipient> recipients) {
        this.payload = push.getPayload();
        this.tags = push.getTags();
        this.keys = push.getKeys();
        this.repack = push.getRepack();
        this.experiments = push.getExperiments();
        this.subscriptions = push.getSubscriptions();

        for (Recipient r : recipients) {
            this.recipients.add(r.getRecipient());
        }
    }
}
