package ru.yandex.direct.xiva.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Уведомление (пуш).
 * Используется для генерации тела запроса к Xiva-серверу.
 * */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Push {
    @JsonProperty("payload")
    private final String payload;

    @JsonProperty("tags")
    private String tags;

    @JsonProperty("keys")
    private String keys;

    @JsonProperty("repack")
    private String repack;

    @JsonProperty("experiments")
    private String experiments;

    @JsonProperty("subscriptions")
    private String subscriptions;

    @JsonIgnore
    private final String description;


    /**
     * Создать уведомление.
     *
     * @param payload тело уведомления - JSON объект или произвольный текст.
     * @param description короткий заголовок уведомления - "что произошло".
     * */
    public Push(String payload, String description) {
        this.payload = payload;
        this.description = description;
    }

    /**
     * Установить теги (для фильтрации уведомлений).
     *
     * @param tags теги - строка в формате JSON.
     * */
    public void setTags(String tags) {
        this.tags = tags;
    }

    /**
     * Установить ключи (используемые в сложных фильтрах подписок).
     *
     * @param keys ключи - строка в формате JSON.
     * */
    public void setKeys(String keys) {
        this.keys = keys;
    }

    /**
     * Установить правила переупаковки данных из payload.
     *
     * @param repack правила - строка в формате JSON.
     * */
    public void setRepack(String repack) {
        this.repack = repack;
    }

    /**
     * Установить список экспериментов, относящихся к уведомлению.
     *
     * @param experiments массив идентификаторов, в виде строки.
     * */
    public void setExperiments(String experiments) {
        this.experiments = experiments;
    }

    /**
     * Установить условия отправки уведомления в подписку.
     *
     * @param subscriptions условия - строка в формате JSON.
     * */
    public void setSubscriptions(String subscriptions) {
        this.subscriptions = subscriptions;
    }

    public String getPayload() {
        return payload;
    }

    public String getTags() {
        return tags;
    }

    public String getKeys() {
        return keys;
    }

    public String getRepack() {
        return repack;
    }

    public String getExperiments() {
        return experiments;
    }

    public String getSubscriptions() {
        return subscriptions;
    }

    public String getDescription() {
        return description;
    }
}
