package ru.yandex.direct.xiva.client.model;

import com.google.common.collect.ImmutableMap;

/**
 * Подписка-получатель уведомления.
 * Используется для генерации тела запроса к Xiva-серверу.
 * */
public class RecipientSubscription implements Recipient {
    private final ImmutableMap<String, String> recipient;

    /**
     * @param user идентификатор пользователя.
     * @param subscription идентификатор подписки пользователя.
     * */
    RecipientSubscription(String user, String subscription) {
        recipient = ImmutableMap.of(user, subscription);
    }

    public ImmutableMap<String, String> getRecipient() {
        return recipient;
    }
}
