package ru.yandex.direct.xiva.client.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SendBatchResponse {
    @JsonProperty("results")
    private LinkedList<Object> results;

    private static final String STATUS_CODE = "code";
    private static final String STATUS_BODY = "body";
    private static final String STATUS_ID = "id";

    public List<Object> getResults() {
        return results;
    }

    public List<SendStatusSingleOrList> getStatuses() {
        LinkedList<SendStatusSingleOrList> result = new LinkedList<>();
        for (int i = 0; i < results.size(); i++) {
            Object item = results.get(i);
            if (item instanceof List) {
                List<LinkedHashMap<String, Object>> sourceList = (ArrayList<LinkedHashMap<String, Object>>) item;
                List<SendStatus> statusesList = new LinkedList<>();
                for (Map map : sourceList) {
                    statusesList.add(
                            new SendStatus(
                                    (Integer) map.get(STATUS_CODE),
                                    (String) map.get(STATUS_BODY),
                                    (String) map.get(STATUS_ID)
                            )
                    );
                }
                result.add(new SendStatusList(statusesList));
            }
            if (item instanceof Map) {
                LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>) item;
                result.add(
                        new SendStatus(
                                (Integer) map.get(STATUS_CODE),
                                (String) map.get(STATUS_BODY),
                                (String) map.get(STATUS_ID)
                        )
                );
            }
        }
        return result;
    }
}
