package ru.yandex.direct.xiva.client.model;

import java.util.LinkedList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SendStatus implements SendStatusSingleOrList {
    @JsonProperty("code")
    private Integer code;

    @JsonProperty("body")
    private String body;

    @JsonProperty("id")
    private String id;

    public SendStatus(int code, String body, String id) {
        this.code = code;
        this.body = body;
        this.id = id;
    }

    public int getCode() {
        return code;
    }

    public String getBody() {
        return body;
    }

    @Override
    public List<SendStatus> getList() {
        LinkedList<SendStatus> result = new LinkedList<>();
        result.add(this);
        return result;
    }

    @Override
    public Boolean isSingle() {
        return true;
    }

    @Override
    public Boolean isList() {
        return false;
    }
}
