package ru.yandex.direct.audience.client;

import ru.yandex.direct.audience.client.model.ConfirmSegmentRequest;
import ru.yandex.direct.audience.client.model.CreateExperimentRequestEnvelope;
import ru.yandex.direct.audience.client.model.CreateExperimentResponseEnvelope;
import ru.yandex.direct.audience.client.model.DeleteSegmentResponse;
import ru.yandex.direct.audience.client.model.SegmentResponse;
import ru.yandex.direct.audience.client.model.SegmentsResponse;
import ru.yandex.direct.audience.client.model.SetExperimentGrantRequestEnvelope;
import ru.yandex.direct.audience.client.model.SetExperimentGrantResponseEnvelope;
import ru.yandex.direct.audience.client.model.geosegment.YaAudienceCreateGeoSegmentRequest;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Body;
import ru.yandex.direct.http.smart.http.DELETE;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.PUT;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;

public interface Api {
    @GET("/v1/management/client/segments")
    @Json
    Call<SegmentsResponse> getSegments(@Query("ulogin") String ulogin);

    @POST("/v1/management/client/segment/{segmentId}/confirm")
    @Json
    @Headers({
            "Accept: application/json",
            "Content-Type: application/json"
    })
    Call<SegmentResponse> confirmSegment(@Path("segmentId") Long segmentId,
                                         @Query("ulogin") String ulogin,
                                         @Query("lang") String lang,
                                         @Body @Json ConfirmSegmentRequest confirmSegmentRequest);

    @POST("/v1/management/experiments")
    @Json
    @Headers({
            "Accept: application/json",
            "Content-Type: application/json"
    })
    Call<CreateExperimentResponseEnvelope> createExpertiment(
            @Query("ulogin") String ulogin,
            @Body @Json CreateExperimentRequestEnvelope createExperimentRequest);

    @PUT("/v1/management/experiment/{experimentId}")
    @Json
    @Headers({
            "Accept: application/json",
            "Content-Type: application/json"
    })
    Call<CreateExperimentResponseEnvelope> updateExperiment(
            @Path("experimentId") Long experimentId,
            @Query("ulogin") String ulogin,
            @Body @Json CreateExperimentRequestEnvelope createExperimentRequest);

    @PUT("/v1/management/experiment/{experimentId}/grant")
    @Json
    @Headers({
            "Accept: application/json",
            "Content-Type: application/json"
    })
    Call<SetExperimentGrantResponseEnvelope> setExperimentGrant(
            @Path("experimentId") Long experimentId,
            @Body @Json SetExperimentGrantRequestEnvelope setExperimentGrantRequest);

    /**
     * Метод для создания геосегмента.
     *
     * @param ulogin  логин пользователя, для которого создается геосегмент
     * @param request запрос
     * @return информация о созданном сегменте
     */
    @POST("/v1/management/segments/create_geo")
    @Json
    @Headers({
            "Accept: application/json",
            "Content-Type: application/json"
    })
    Call<SegmentResponse> createGeoSegment(@Query("ulogin") String ulogin,
                                           @Body @Json YaAudienceCreateGeoSegmentRequest request);

    /**
     * Удаляет геосегмент.
     *
     * @param segmentId - id сегмента
     * @return получилось ли удалить сегмент
     */
    @DELETE("/v1/management/segment/{segmentId}")
    @Json
    Call<DeleteSegmentResponse> deleteSegment(@Path("segmentId") Long segmentId);
}
