package ru.yandex.direct.audience.client;

import org.asynchttpclient.request.body.multipart.PartBase;

import ru.yandex.direct.audience.client.model.SegmentResponse;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Multipart;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Part;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;

public interface UploadApi {

    @POST("/v1/management/client/segments/upload_file")
    @Multipart
    @Json
    Call<SegmentResponse> uploadFile(@Query("ulogin") String ulogin, @Part PartBase fileData);

    @POST("/v1/management/client/segment/{segmentId}/modify_data")
    @Multipart
    @Json
    Call<SegmentResponse> modifySegment(@Path("segmentId") Long segmentId,
                                        @Query("ulogin") String ulogin,
                                        @Query("modification_type") String modificationType,
                                        @Part PartBase fileData);
}
