package ru.yandex.direct.audience.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ConfirmingSegment {

    @JsonProperty(value = "id")
    private Long segmentId;

    @JsonProperty(value = "name")
    private String name;

    @JsonProperty(value = "content_type")
    private SegmentContentType contentType;

    @JsonProperty(value = "hashed")
    private boolean hashed;

    public Long getSegmentId() {
        return segmentId;
    }

    public ConfirmingSegment withSegmentId(final Long segmentId) {
        this.segmentId = segmentId;
        return this;
    }

    public ConfirmingSegment withName(final String name) {
        this.name = name;
        return this;
    }

    public ConfirmingSegment withContentType(final SegmentContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ConfirmingSegment withHashed(final boolean hashed) {
        this.hashed = hashed;
        return this;
    }

}
