package ru.yandex.direct.audience.client.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CreateExperimentRequest {
    @JsonProperty("name")
    private String experimentName;

    @JsonProperty("counter_ids")
    private List<Long> counterIds;

    @JsonInclude(JsonInclude.Include.NON_NULL)
    @JsonProperty("bk_settings")
    private String bkSettings;

    @JsonProperty("segments")
    private List<ExperimentSegmentRequest> experimentSegmentRequests;

    public String getExperimentName() {
        return experimentName;
    }

    public CreateExperimentRequest withExperimentName(String experimentName) {
        this.experimentName = experimentName;
        return this;
    }

    public List<Long> getCounterIds() {
        return counterIds;
    }

    public CreateExperimentRequest withCounterIds(List<Long> counterIds) {
        this.counterIds = counterIds;
        return this;
    }

    public String getBkSettings() {
        return bkSettings;
    }

    public CreateExperimentRequest withBkSettings(String bkSettings) {
        this.bkSettings = bkSettings;
        return this;
    }

    public List<ExperimentSegmentRequest> getExperimentSegmentRequests() {
        return experimentSegmentRequests;
    }

    public CreateExperimentRequest withExperimentSegmentRequests(List<ExperimentSegmentRequest> experimentSegmentRequests) {
        this.experimentSegmentRequests = experimentSegmentRequests;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateExperimentRequest that = (CreateExperimentRequest) o;
        return Objects.equals(experimentName, that.experimentName) &&
                Objects.equals(counterIds, that.counterIds) &&
                Objects.equals(bkSettings, that.bkSettings) &&
                Objects.equals(experimentSegmentRequests, that.experimentSegmentRequests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(experimentName, counterIds, bkSettings, experimentSegmentRequests);
    }
}
