package ru.yandex.direct.audience.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ExperimentSegmentRequest {
    @JsonProperty("name")
    private String name;

    @JsonProperty("start")
    private Integer start;

    @JsonProperty("end")
    private Integer end;

    public String getName() {
        return name;
    }

    public ExperimentSegmentRequest withName(String name) {
        this.name = name;
        return this;
    }

    public Integer getStart() {
        return start;
    }

    public ExperimentSegmentRequest withStart(Integer start) {
        this.start = start;
        return this;
    }

    public Integer getEnd() {
        return end;
    }

    public ExperimentSegmentRequest withEnd(Integer end) {
        this.end = end;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExperimentSegmentRequest that = (ExperimentSegmentRequest) o;
        return Objects.equals(name, that.name) &&
                Objects.equals(start, that.start) &&
                Objects.equals(end, that.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, start, end);
    }
}
