package ru.yandex.direct.audience.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class SetExperimentGrantRequest {
    @JsonProperty("user_login")
    private String userLogin;

    @JsonProperty("permission")
    private String permission;

    public String getUserLogin() {
        return userLogin;
    }

    public SetExperimentGrantRequest withUserLogin(String userLogin) {
        this.userLogin = userLogin;
        return this;
    }

    public String getPermission() {
        return permission;
    }

    public SetExperimentGrantRequest withPermission(String permission) {
        this.permission = permission;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SetExperimentGrantRequest that = (SetExperimentGrantRequest) o;
        return Objects.equals(userLogin, that.userLogin) &&
                Objects.equals(permission, that.permission);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userLogin, permission);
    }
}
