package ru.yandex.direct.audience.client.model.geosegment;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Документация к полям сегмента с типом «геолокация-окружности»
 * https://yandex.ru/dev/audience/doc/segments/creategeo.html
 */
@ParametersAreNonnullByDefault
public class YaAudienceCreateGeoSegmentRequest {

    @JsonProperty("segment")
    private YaAudienceGeoSegment segment;

    public YaAudienceCreateGeoSegmentRequest(YaAudienceGeoSegment segment) {
        this.segment = segment;
    }

    public YaAudienceGeoSegment getSegment() {
        return segment;
    }

    public void setSegment(YaAudienceGeoSegment segment) {
        this.segment = segment;
    }
}
