package ru.yandex.direct.audience.client.model.geosegment;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

public class YaAudienceGeoPoint {

    @JsonProperty("latitude")
    private Double latitude;

    @JsonProperty("longitude")
    private Double longitude;

    @JsonProperty("description")
    private String description;

    public YaAudienceGeoPoint(Double latitude, Double longitude) {
        this(latitude, longitude, null);
    }

    public YaAudienceGeoPoint(Double latitude, Double longitude, String description) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.description = description;
    }

    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YaAudienceGeoPoint that = (YaAudienceGeoPoint) o;
        return Objects.equals(latitude, that.latitude) &&
                Objects.equals(longitude, that.longitude) &&
                Objects.equals(description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(latitude, longitude, description);
    }
}
