package ru.yandex.direct.audience.client.model.geosegment;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

public class YaAudienceGeoSegment {

    @JsonProperty("name")
    private String name;

    @JsonProperty("radius")
    private Integer radius;

    // Период посещений указанных мест. Для создания условия «Пользователь посетил указанные места N раз за период»
    @JsonProperty("period_length")
    private Integer periodLength;

    // Частота посещений указанных мест. Для создания условия «Пользователь посетил указанные места N раз за период»
    @JsonProperty("times_quantity")
    private Integer timesQuantity;

    @JsonProperty("points")
    private Set<YaAudienceGeoPoint> points;

    @JsonProperty("geo_segment_type")
    private YaAudienceGeoSegmentType geoSegmentType;

    public YaAudienceGeoSegment() {
    }

    public YaAudienceGeoSegment(
            String name,
            Integer radius,
            Set<YaAudienceGeoPoint> points,
            YaAudienceGeoSegmentType geoSegmentType,
            Integer periodLength,
            Integer timesQuantity) {
        this.name = name;
        this.radius = radius;
        this.points = points;
        this.geoSegmentType = geoSegmentType;
        this.periodLength = periodLength;
        this.timesQuantity = timesQuantity;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRadius() {
        return radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    public Set<YaAudienceGeoPoint> getPoints() {
        return points;
    }

    public void setPoints(Set<YaAudienceGeoPoint> points) {
        this.points = points;
    }

    public YaAudienceGeoSegmentType getGeoSegmentType() {
        return geoSegmentType;
    }

    public void setGeoSegmentType(YaAudienceGeoSegmentType geoSegmentType) {
        this.geoSegmentType = geoSegmentType;
    }

    public Integer getPeriodLength() {
        return periodLength;
    }

    public void setPeriodLength(Integer periodLength) {
        this.periodLength = periodLength;
    }

    public Integer getTimesQuantity() {
        return timesQuantity;
    }

    public void setTimesQuantity(Integer timesQuantity) {
        this.timesQuantity = timesQuantity;
    }
}
