package ru.yandex.direct.audience.client.model.geosegment;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

public enum YaAudienceGeoSegmentType {

    @JsonProperty("last")
    LAST("last"),

    @JsonProperty("regular")
    REGULAR("regular"),

    @JsonProperty("home")
    HOME("home"),

    @JsonProperty("work")
    WORK("work"),

    @JsonProperty("condition")
    CONDITION("condition");

    private static final Map<String, YaAudienceGeoSegmentType> ENUMS = Arrays.stream(values())
            .collect(Collectors.toMap(YaAudienceGeoSegmentType::getTypedValue, e -> e));

    private final String typedValue;

    YaAudienceGeoSegmentType(String typedValue) {
        this.typedValue = typedValue;
    }

    public String getTypedValue() {
        return typedValue;
    }

    public static YaAudienceGeoSegmentType fromTypedValue(@Nullable String typedValue) {
        if (typedValue == null) {
            return null;
        }
        YaAudienceGeoSegmentType result = ENUMS.get(typedValue);
        if (result == null) {
            throw new IllegalArgumentException("Unknown enum typed value " + typedValue);
        }
        return result;
    }
}
