package ru.yandex.direct.captcha.passport;

import com.google.common.base.Preconditions;

/**
 * Параметры подключения к Yandex.Captcha. tcp-соединение будет установлено с {@link #urlBase},
 * однако есть возможность указать HttpHeader Host явно, задав {@link #httpHostHeader}. Это полезно при работе через Proxy - в частности,
 * так осуществляется работа на машинах разработчиков и ppcdev* серверах.
 */
public class YandexCaptchaConfig {
    private final String urlBase;
    private final String httpHostHeader;

    public YandexCaptchaConfig(String urlBase, String httpHostHeader) {
        this.urlBase = Preconditions.checkNotNull(urlBase);
        this.httpHostHeader = Preconditions.checkNotNull(httpHostHeader);
    }

    public String getUrlBase() {
        return urlBase;
    }

    public String getHttpHostHeader() {
        return httpHostHeader;
    }
}
